// Rim Shader test - vertex
// see "http://www.fundza.com/rman_shaders/surface/fake_rim/fake_rim1.html" for a good explanation of rim shading
// 2006 Michael Mandel

varying vec3  Normal;
varying vec3  EyeDir;
varying vec4  EyePos;
varying float LightIntensity;

void main(void) 
{
    gl_Position    = ftransform();
    Normal         = normalize(gl_NormalMatrix * gl_Normal);
    vec4 pos       = gl_ModelViewMatrix * gl_Vertex;
    EyeDir         = pos.xyz;
    EyePos		   = gl_ModelViewProjectionMatrix * gl_Vertex;
    
    const vec3 lightPos = vec3(0.0, 0.0, 0.0);
    LightIntensity = max(dot(normalize(lightPos - EyeDir), Normal), 0.0);
}